'use strict';

/* Controllers */
function BCPPersonnelCtrl($scope, $rootScope, $route, Company, RandomEmployeesList){

    Company.init();
    $scope.company =  Company;

    $scope.usersList = $route.current.locals.usersList;
    $scope.companyRoleTypes = $route.current.locals.companyRoleTypes;
    $scope.RandomEmployeesList = RandomEmployeesList;
    $scope.employees = RandomEmployeesList.loadData();
    $scope.employeesFilterTypes = RandomEmployeesList.filterTypes;

    $scope.departments = $scope.company.departments;

    $scope.methodType = 'bcp-personnel';

    $scope.priceManagement = 10000;

    $scope.areaForPeople = 12;
    $scope.criticalAreaForPeople = 8;
    $scope.search = {};

    $scope.shifts = 1;



    $scope.showJobs = function(department) {
        $rootScope.$broadcast('Jobs:openWindow',department);
    }

    $scope.showPersonnelCV = function(employee) {
        $rootScope.$broadcast('Personnel:openPersonnelCVModal',employee);
    }

    $scope.showConditions = function(conditions) {
        angular.element('#modal-conditions').modal('show');
    }

    $scope.showUsers = function() {
        angular.element('#modal-users-list').modal('show');
    }

    $scope.showToken = function() {
        var params = {};
        params.title = 'Oferty pracy';
        params.tokensConfirmsMessage = 'controlPanel,'+'personnel';
        params.typeSubmitToken = 'REPRESENTATION';
        params.changes = [];
        $scope.departments.forEach(function(Department){
            if(Department.isChanged())
            {
                Department.employees.forEach(function(Employee){
                    if(Employee.isFired())
                    {
                        params.changes.push(Department.name + ': Zwolnienie pracownika ' + Employee.getFullName());
                    }
                    else if(Employee.isHired())
                    {
                        params.changes.push(Department.name + ': Zatrudnienie pracownika ' + Employee.getFullName());
                    }
                });
            }
        })
        params.modal = true;

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.company, params, $scope.methodType);
//        $rootScope.$broadcast('Tokens:closeSubmitTokensModal', $scope.methodType);
    }

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType){
            var message = {
                title: 'Ludzie'
                ,msg: 'Zapisuję zmiany w departamentach. Proszę czekać...'
            }
            $scope.company.departments.forEach(function(Department){
                if(Department.isChanged())
                {
                    $rootScope.$broadcast('Message:addMsg', message);
                    Department.saveChanges(function(){
                        $rootScope.$broadcast('Message:delMsg', message);
                    });
                }
            });
        }
    });

    $scope.checkJob = function(job) {
        job.checked = !job.checked;
    }

    $scope.checkUser = function(user) {
        if(user.company_roles.length != 0){
            user.company_roles = [];
        }else if(user.company_roles.length == 0){
            user.company_roles.push($scope.companyRoleTypes.M);
        }
    }

//    $scope.countDepartmentPrice = function(employeesList) {
//        var departmentPrice = 0;
//
//        angular.forEach(employeesList, function(employee) {
//            departmentPrice += employee.price;
//        });
//
//        return departmentPrice;
//    }

    $scope.isCompanyRoleInUser = function(user, roleSymbol) {
        var isRole = false;
        angular.forEach(user.company_roles, function(role) {
            if(role.symbol == roleSymbol) {
                isRole = true;
                return true;
            }
        });
        return isRole;
    }

    $scope.getCostManagement = function(){
        var cost = 0;
        angular.forEach($scope.company.user_groups.users, function(user) {
            if($scope.isCompanyRoleInUser(user, 'M') || $scope.isCompanyRoleInUser(user, 'C')) {
                cost += $scope.priceManagement;
            }
        });
        return cost;
    }

    $scope.getAllCost = function() {
        var cost = 0;
        angular.forEach($scope.departments, function(department) {
            cost += department.getCostEmployees();
        });
        cost += $scope.getCostManagement();

        return cost;
    }

    $scope.getAllOfficeEmployees = function() {
//        var managment = $scope.usersList.filter(function(user){return user.company_roles.length > 0});
        var employees = 0;

//        employees += managment.length;
        angular.forEach($scope.departments, function(department) {
            if(typeof department.employees != 'undefined')
            {
                employees += department.getNumberOfEmployees();
            }
        });

        return employees;
    }


    $scope.getManagementLength = function(){
        var count = 0;
        $scope.usersList.forEach(function(user){
            if(user.company_roles.length > 0)
            {
                count++;
            }
        });

        return count;
    }


    $scope.showEmployees = function (department){
        $rootScope.$broadcast('Employees:openWindow', department);
    }

    $scope.isAnyChanged = function(){
        var isChanged = false;
        for(var i = 0; i < $scope.company.departments.length; i++)
        {
            if($scope.company.departments[i].isChanged())
            {
                isChanged = true;
                break;
            }
        }
        return isChanged;
    }
}

BCPPersonnelCtrl.$inject = ['$scope', '$rootScope', '$route', 'Company', 'RandomEmployeesList'];

BCPPersonnelCtrl.getUsersInGroupForLoggedUser = function($q, $route, $rootScope, FrontCreatorUsersInGroupForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorUsersInGroupForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPPersonnelCtrl.getCompanyRoleTypes = function($q, $route, $rootScope, FrontCreatorUserCompanyRoleTypes){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorUserCompanyRoleTypes.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPPersonnelCtrl.getEmployees = function($q, $route, $rootScope, FrontCreatorEmployee){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorEmployee.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPPersonnelCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPPersonnelCtrl.getDepartments = function($q, $route, $rootScope, FrontCreatorDepartments){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorDepartments.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}